<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Hospitalization Entity.
 *
 * @property int $id
 * @property int $patient_id
 * @property \App\Model\Entity\Patient $patient
 * @property string $health_care_number
 * @property string $type
 * @property string $complementary_health
 * @property \Cake\I18n\Time $expected_discharge_day
 * @property int $screening_id
 * @property \App\Model\Entity\Screening $screening
 * @property int $origin_id
 * @property \App\Model\Entity\Origin $origin
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 * @property \Cake\I18n\Time $created
 * @property string $updated
 * @property bool $readmission_to_hospital_until_30_days
 * @property bool $rehospitalization_up_24
 * @property float $weight
 * @property float $height
 * @property string $systemic_diagnosis
 * @property string $comorbidities
 * @property \App\Model\Entity\Bundle[] $bundle
 * @property \App\Model\Entity\CardiacSurgeryChecklist[] $cardiac_surgery_checklists
 * @property \App\Model\Entity\DailySafetyChecklist[] $daily_safety_checklists
 * @property \App\Model\Entity\FugulinAndBraden[] $fugulin_and_braden
 * @property \App\Model\Entity\Infection[] $infections
 * @property \App\Model\Entity\InitialNutritionalAssessment[] $initial_nutritional_assessment
 * @property \App\Model\Entity\MedicalBulletin[] $medical_bulletins
 * @property \App\Model\Entity\MedicalOpinionRequest[] $medical_opinion_requests
 * @property \App\Model\Entity\Prescription[] $prescriptions
 */
class Hospitalization extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
