<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Diagnostic Entity.
 *
 * @property int $id
 * @property \App\Model\Entity\Origin $origin
 * @property \Cake\I18n\Time $created
 * @property \Cake\I18n\Time $modified
 * @property string $type
 * @property string $description
 * @property bool $is_possible_diagnosis
 * @property int $patient_id
 * @property \App\Model\Entity\Patient $patient
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property \Cake\I18n\Time $diagnostic_date
 * @property int $origin_id
 * @property int $medical_care_id
 * @property \App\Model\Entity\MedicalCare $medical_care
 * @property string $emergency_surgery
 * @property string $routine_surgery
 * @property string $clinic
 * @property string $grave_comorbidities
 * @property \App\Model\Entity\OtherComorbidity[] $other_comorbidities
 * @property \App\Model\Entity\Comorbidity[] $comorbidities
 */
class Diagnostic extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
